/************************************************************/
/* PROJECT NAME: SWI	                                    */
/* Project:      LPC2100 Training course                    */
/* Engineer:     T Martin      tmartin@hitex.co.uk          */
/* Filename:     main.c                                     */
/* Language:     C                      	                */
/* Compiler:     Keil ARM		V2.00b	              		*/
/* Assembler:    				               				*/
/*                                                          */
/************************************************************/
/* COPYRIGHT: Hitex UK Ltd 		2005						*/
/* LICENSE:   THIS VERSION CREATED FOR FREE DISTRIBUTION	*/
/************************************************************/
/* Function:                                                */
/*                                                          */
/* Example software interrupt for LPC2100              		*/
/*															*/
/* Demonstrates serving an SWI and running selected code	*/
/*															*/	
/* Oscillator frequency 12.000 Mhz							*/
/* Target board Keil MCB21000								*/
/************************************************************/




#include <LPC21xx.H> 


void SWI_Call1(int pattern) 				//Software interrupt with passed parameters
{

IOCLR1 		= 0x00FF0000;			 		//set the leds
IOSET1 		= pattern;						
}

void SWI_Call2(void)    					//void call to software intterupt
{
IOCLR1 		= 0x00FF0000;			 		//write default pattern to the LEDs
IOSET1 		= 0x00AA0000;
}


void main(void)
{
int pattern = 0x00550000;
IODIR1 		= 0x00FF0000;					//Set LED pins as outputs
IOCLR1 		= 0x00FF0000;					//Generate software interrupt

SWI_Call1(pattern);							//call software interrupt

SWI_Call2();								//Call second software interrupt
									

while(1)
{
;											//Loop forever
}
}

